/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.buddingcrystals.common.datagen.providers;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import xfacthd.buddingcrystals.common.BCContent;
import xfacthd.buddingcrystals.common.util.ConfigCondition;
import xfacthd.buddingcrystals.common.util.CrystalSet;

public final class BuddingRecipeProvider
extends RecipeProvider {
    public BuddingRecipeProvider(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        BuddingRecipeProvider.addBuddingCrystalRecipe(BCContent.AMETHYST, true, consumer);
        BCContent.builtinSets().forEach(set -> BuddingRecipeProvider.addBuddingCrystalRecipe(set, true, consumer));
        ShapedRecipeBuilder.m_126116_((ItemLike)((ItemLike)BCContent.CRYSTAL_CATALYST.get())).m_126130_("RBR").m_126130_("BAB").m_126130_("RBR").m_206416_(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42593_).m_126127_(Character.valueOf('A'), (ItemLike)Items.f_151049_).m_142284_("hasAmethyst", (CriterionTriggerInstance)BuddingRecipeProvider.m_125977_((ItemLike)Items.f_151049_)).m_176498_(consumer);
    }

    public static void addBuddingCrystalRecipe(CrystalSet set, boolean config, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126116_((ItemLike)set.getBuddingBlock()).m_126130_("MMM").m_126130_("MCM").m_126130_("MMM").m_126127_(Character.valueOf('M'), (ItemLike)set.getIngredient()).m_126127_(Character.valueOf('C'), (ItemLike)BCContent.CRYSTAL_CATALYST.get()).m_142284_("has_" + set.getName(), (CriterionTriggerInstance)BuddingRecipeProvider.m_125977_((ItemLike)set.getIngredient()));
        BuddingRecipeProvider.wrapInConditions(set, (RecipeBuilder)builder, config, consumer);
    }

    private static void wrapInConditions(CrystalSet set, RecipeBuilder builder, boolean config, Consumer<FinishedRecipe> consumer) {
        boolean minecraft = set.getCompatMod().equals("minecraft");
        if (!config && minecraft) {
            builder.m_176498_(consumer);
            return;
        }
        ConditionalRecipe.Builder conditionalBuilder = ConditionalRecipe.builder();
        if (!minecraft) {
            ModLoadedCondition modCondition = new ModLoadedCondition(set.getCompatMod());
            conditionalBuilder.addCondition((ICondition)modCondition);
        }
        if (config) {
            ConfigCondition cfgCondition = new ConfigCondition(set.getConfigString());
            conditionalBuilder.addCondition((ICondition)cfgCondition);
        }
        FinishedRecipe[] recipe = new FinishedRecipe[1];
        builder.m_176498_(finishedRecipe -> {
            recipe[0] = finishedRecipe;
        });
        conditionalBuilder.addRecipe(recipe[0]).generateAdvancement(recipe[0].m_6448_()).build(consumer, RecipeBuilder.m_176493_((ItemLike)builder.m_142372_()));
    }
}

